﻿using System;
using VA.TMP.Integration.VIMT.VirtualMeetingRoom.StateObject;
using VIMT.VirtualMeetingRoom.Messages;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VirtualMeetingRoom.PipelineSteps.Create
{
    /// <summary>
    /// Post to Vyopta step.
    /// </summary>
    public class CreateMeetingRoomeRequestStep : FilterBase<VirtualMeetingRoomCreateStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(VirtualMeetingRoomCreateStateObject state)
        {
            if (state.UseFakeResponse || state.ExceptionOccured) return;

            var ecVmrRequest = new VIMTVyoptaSMScheduleMeetingRequest
            {
                // TODO - should get these values from CRM
                OrganizationName = state.OrganizationName,
                UserId = state.UserId,
                LogTiming = false,
                LogSoap = false,
                Debug = false,
                schedulemeetingrequestInfo = new VIMTVyoptaSMschedulemeetingrequest
                {
                    mcs_EncounterId = state.AppointmentId.ToString(),
                    mcs_EndTime = state.AppointmentEndDate,
                    mcs_GuestName = state.PatientId.ToString(),
                    mcs_GuestPin = state.PatientPin,
                    mcs_HostName = state.ProviderId.ToString(),
                    mcs_HostPin = state.ProviderPin,
                    mcs_MeetingRoomName = state.MeetingRoomName,
                    mcs_MiscData = state.MiscDataForRequest,
                    mcs_StartTime = state.AppointmentStartDate
                }
            };

            // Call the Enterprise Component to send the meeting info to Vyopta
            try
            {
                var response = ecVmrRequest.SendReceive<VIMTVyoptaSMScheduleMeetingResponse>(MessageProcessType.Local);

                if (response.ExceptionOccured)
                {
                    state.ExceptionOccured = true;
                    state.ExceptionMessage = response.ExceptionMessage;
                }
                else
                {
                    if (response.VIMTVyoptaSMScheduleMeetingResponseDataInfo != null)
                    {
                        if (response.VIMTVyoptaSMScheduleMeetingResponseDataInfo.mcs_EncounterId != state.AppointmentId.ToString())
                        {
                            state.ExceptionOccured = true;
                            state.ExceptionMessage = string.Format("The EncounterId {0} returned from Vyopta does not match the AppointmentId {1} from TMP", response.VIMTVyoptaSMScheduleMeetingResponseDataInfo.mcs_EncounterId, state.AppointmentId);
                        }
                        else
                        {
                            state.CorrelationId = response.VIMTVyoptaSMScheduleMeetingResponseDataInfo.mcs_EncounterId;
                            state.DialingAlias = response.VIMTVyoptaSMScheduleMeetingResponseDataInfo.mcs_DialingAlias;
                            state.MiscDataForResponse = response.VIMTVyoptaSMScheduleMeetingResponseDataInfo.mcs_MiscData;
                        }
                    }
                    else
                    {
                        state.ExceptionOccured = true;
                        state.ExceptionMessage = "The VIMTVyoptaSMScheduleMeetingResponseDataInfo response value is null";
                    }
                }
            }
            catch (Exception ex)
            {
                var exceptionMessage = ex.Message;
                exceptionMessage += Shared.PipelineUtilities.BuildErrorMessage(ex);

                state.ExceptionOccured = true;
                state.ExceptionMessage = exceptionMessage;
            }
        }
    }
}